// =========================
// Tactics ステージ管理
// =========================
const TacticsStages = {};

// ★ステージ定義
TacticsStages.data = {
    1: {
        name: "ステージ1：チュートリアル",
        mapWidth: 8,
        mapHeight: 6,
        allies: [
            // id, name, x, y, hp, atk, def, mov, team, rangeMin, rangeMax
            { id: 1, name: "剣士A", x: 1, y: 1, hp: 20, atk: 8, def: 3, mov: 3, rangeMin: 1, rangeMax: 1 },
            { id: 2, name: "槍兵A", x: 1, y: 3, hp: 18, atk: 7, def: 2, mov: 3, rangeMin: 1, rangeMax: 2 },
        ],
        enemies: [
            { id: 101, name: "山賊1", x: 6, y: 1, hp: 15, atk: 6, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 102, name: "弓兵1", x: 6, y: 4, hp: 14, atk: 6, def: 1, mov: 2, rangeMin: 2, rangeMax: 3 },
        ],


    },
    2: {
        name: "ステージ2：挟み撃ち",
        mapWidth: 8,
        mapHeight: 6,
        allies: [
            { id: 1, name: "剣士A", x: 1, y: 2, hp: 20, atk: 8, def: 3, mov: 3, rangeMin: 1, rangeMax: 1 },
            { id: 2, name: "槍兵A", x: 1, y: 3, hp: 18, atk: 7, def: 2, mov: 3, rangeMin: 1, rangeMax: 2 },
        ],
        enemies: [
            { id: 201, name: "山賊2", x: 6, y: 1, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 202, name: "山賊3", x: 6, y: 4, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 203, name: "弓兵2", x: 3, y: 0, hp: 14, atk: 6, def: 1, mov: 2, rangeMin: 2, rangeMax: 3 },
        ]
    },
    // 3〜10も同じノリで増やしていく

    3: {
        name: "ステージ2：挟み撃ち",
        mapWidth: 8,
        mapHeight: 6,
        allies: [
            { id: 1, name: "剣士A", x: 0, y: 0, hp: 20, atk: 8, def: 3, mov: 3, rangeMin: 1, rangeMax: 1 },
            { id: 2, name: "弓兵A", x: 0, y: 3, hp: 18, atk: 7, def: 2, mov: 3, rangeMin: 1, rangeMax: 3 },
        ],
        enemies: [
            { id: 201, name: "山賊2", x: 7, y: 0, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 202, name: "山賊3", x: 6, y: 4, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },

        ],

        blocks: [
            { x: 1, y: 0 },
            { x: 2, y: 0 },
            { x: 3, y: 0 },
            { x: 3, y: 1 },
            { x: 3, y: 2 },
            { x: 0, y: 4}, 
            { x: 1, y: 4 },
            { x: 2, y: 4 },
            { x: 3, y: 4 },
            { x: 5, y: 0 },
            { x: 6, y: 0}, 
            { x: 5, y: 1 },
            { x: 6, y: 1}, 
            { x: 5, y: 2 },
            { x: 6, y: 2}, 
            { x: 5, y: 5 },
            { x: 6, y: 5},
            { x: 5, y: 6 },
            { x: 6, y: 6},  
            { x: 7, y: 6 },
            { x: 7, y: 7}, 
            // こんな感じで好きなだけ
        ]


    },

    4: {
        name: "ステージ2：挟み撃ち",
        mapWidth: 8,
        mapHeight: 6,
        allies: [
            { id: 1, name: "剣士A", x: 1, y: 2, hp: 20, atk: 8, def: 3, mov: 3, rangeMin: 1, rangeMax: 1 },
            { id: 2, name: "槍兵A", x: 1, y: 3, hp: 18, atk: 7, def: 2, mov: 3, rangeMin: 1, rangeMax: 2 },
        ],
        enemies: [
            { id: 201, name: "山賊2", x: 6, y: 1, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 202, name: "山賊3", x: 6, y: 4, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 203, name: "弓兵2", x: 3, y: 0, hp: 14, atk: 6, def: 1, mov: 2, rangeMin: 2, rangeMax: 3 },
        ]
    },
        5: {
        name: "ステージ2：挟み撃ち",
        mapWidth: 8,
        mapHeight: 6,
        allies: [
            { id: 1, name: "剣士A", x: 1, y: 2, hp: 20, atk: 8, def: 3, mov: 3, rangeMin: 1, rangeMax: 1 },
            { id: 2, name: "槍兵A", x: 1, y: 3, hp: 18, atk: 7, def: 2, mov: 3, rangeMin: 1, rangeMax: 2 },
        ],
        enemies: [
            { id: 201, name: "山賊2", x: 6, y: 1, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 202, name: "山賊3", x: 6, y: 4, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 203, name: "弓兵2", x: 3, y: 0, hp: 14, atk: 6, def: 1, mov: 2, rangeMin: 2, rangeMax: 3 },
        ]
    },
        6: {
        name: "ステージ2：挟み撃ち",
        mapWidth: 8,
        mapHeight: 6,
        allies: [
            { id: 1, name: "剣士A", x: 1, y: 2, hp: 20, atk: 8, def: 3, mov: 3, rangeMin: 1, rangeMax: 1 },
            { id: 2, name: "槍兵A", x: 1, y: 3, hp: 18, atk: 7, def: 2, mov: 3, rangeMin: 1, rangeMax: 2 },
        ],
        enemies: [
            { id: 201, name: "山賊2", x: 6, y: 1, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 202, name: "山賊3", x: 6, y: 4, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 203, name: "弓兵2", x: 3, y: 0, hp: 14, atk: 6, def: 1, mov: 2, rangeMin: 2, rangeMax: 3 },
        ]
    },
        7: {
        name: "ステージ2：挟み撃ち",
        mapWidth: 8,
        mapHeight: 6,
        allies: [
            { id: 1, name: "剣士A", x: 1, y: 2, hp: 20, atk: 8, def: 3, mov: 3, rangeMin: 1, rangeMax: 1 },
            { id: 2, name: "槍兵A", x: 1, y: 3, hp: 18, atk: 7, def: 2, mov: 3, rangeMin: 1, rangeMax: 2 },
        ],
        enemies: [
            { id: 201, name: "山賊2", x: 6, y: 1, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 202, name: "山賊3", x: 6, y: 4, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 203, name: "弓兵2", x: 3, y: 0, hp: 14, atk: 6, def: 1, mov: 2, rangeMin: 2, rangeMax: 3 },
        ]
    },
        8: {
        name: "ステージ2：挟み撃ち",
        mapWidth: 8,
        mapHeight: 6,
        allies: [
            { id: 1, name: "剣士A", x: 1, y: 2, hp: 20, atk: 8, def: 3, mov: 3, rangeMin: 1, rangeMax: 1 },
            { id: 2, name: "槍兵A", x: 1, y: 3, hp: 18, atk: 7, def: 2, mov: 3, rangeMin: 1, rangeMax: 2 },
        ],
        enemies: [
            { id: 201, name: "山賊2", x: 6, y: 1, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 202, name: "山賊3", x: 6, y: 4, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 203, name: "弓兵2", x: 3, y: 0, hp: 14, atk: 6, def: 1, mov: 2, rangeMin: 2, rangeMax: 3 },
        ]
    },
        9: {
        name: "ステージ2：挟み撃ち",
        mapWidth: 8,
        mapHeight: 6,
        allies: [
            { id: 1, name: "剣士A", x: 1, y: 2, hp: 20, atk: 8, def: 3, mov: 3, rangeMin: 1, rangeMax: 1 },
            { id: 2, name: "槍兵A", x: 1, y: 3, hp: 18, atk: 7, def: 2, mov: 3, rangeMin: 1, rangeMax: 2 },
        ],
        enemies: [
            { id: 201, name: "山賊2", x: 6, y: 1, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 202, name: "山賊3", x: 6, y: 4, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 203, name: "弓兵2", x: 3, y: 0, hp: 14, atk: 6, def: 1, mov: 2, rangeMin: 2, rangeMax: 3 },
        ]
    },
        10: {
        name: "ステージ2：挟み撃ち",
        mapWidth: 8,
        mapHeight: 6,
        allies: [
            { id: 1, name: "剣士A", x: 1, y: 2, hp: 20, atk: 8, def: 3, mov: 3, rangeMin: 1, rangeMax: 1 },
            { id: 2, name: "槍兵A", x: 1, y: 3, hp: 18, atk: 7, def: 2, mov: 3, rangeMin: 1, rangeMax: 2 },
        ],
        enemies: [
            { id: 201, name: "山賊2", x: 6, y: 1, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 202, name: "山賊3", x: 6, y: 4, hp: 16, atk: 7, def: 2, mov: 2, rangeMin: 1, rangeMax: 1 },
            { id: 203, name: "弓兵2", x: 3, y: 0, hp: 14, atk: 6, def: 1, mov: 2, rangeMin: 2, rangeMax: 3 },
        ]
    },




  };


TacticsStages.createBattle = function(stageId) {
    const data = this.data[stageId];

    // なかったらステージ1にフォールバック
    const s = data || this.data[1];

    // ★ blocks を渡す
    const map = new BattleMap(s.mapWidth, s.mapHeight, s.blocks || []);
    // ユニット生成（今の Unit クラスに合わせて）
    const allies = s.allies.map(d => {
        return new Unit(
            d.id, d.name,
            d.x, d.y,
            d.hp, d.atk, d.def,
            d.mov,
            'ally',
            d.rangeMin, d.rangeMax
        );
    });

    const enemies = s.enemies.map(d => {
        return new Unit(
            d.id, d.name,
            d.x, d.y,
            d.hp, d.atk, d.def,
            d.mov,
            'enemy',
            d.rangeMin, d.rangeMax
        );
    });

    // TacticsBattle は今まで使ってたやつ
    return new TacticsBattle(map, allies, enemies);
};



class Unit {
  constructor(id, name, x, y, hp, atk, def, mov, team,rangeMin = 1, rangeMax = 1) {
    this.id = id;
    this.name = name;
    this.x = x;
    this.y = y;
    this.maxHp = hp;
    this.hp = hp;
    this.atk = atk;
    this.def = def;
    this.mov = mov;
    this.team = team; // 'ally' or 'enemy'
    this.acted = false;

    // ★ 追加：攻撃射程
    this.rangeMin = rangeMin; // 近すぎると当たらない距離（弓1-2マス外とか）
    this.rangeMax = rangeMax; // 最大射程

  }

  alive() {
    return this.hp > 0;
  }

  takeDamage(dmg) {
    this.hp -= dmg;
    if (this.hp < 0) this.hp = 0;
  }
}


class BattleMap {
  constructor(width, height, blocks = []) {
    this.width  = width;
    this.height = height;

    // ★ 通行不能マスを "x,y" → true のマップにして保持
    this._blocked = {};
    blocks.forEach(t => {
      const key = `${t.x},${t.y}`;
      this._blocked[key] = true;
    });
  }

  inBounds(x, y) {
    return x >= 0 && y >= 0 && x < this.width && y < this.height;
  }

  isPassable(x, y) {
    if (!this.inBounds(x, y)) return false;

    const key = `${x},${y}`;
    // _blocked が必ず {} で初期化されていればここで落ちない
    return !this._blocked[key];
  }
}





// マップ内かどうかのチェック
BattleMap.prototype.inBounds = function(x, y) {
    return x >= 0 && y >= 0 && x < this.width && y < this.height;
};

// ★通行可能かどうか
BattleMap.prototype.isPassable = function(x, y) {
    if (!this.inBounds(x, y)) return false;
    const key = `${x},${y}`;
    return !this._blocked[key]; // 登録されてなければ通れる
};





class TacticsBattle {
  constructor(map, allies, enemies) {
    this.map = map;
    this.allies = allies;
    this.enemies = enemies;
    this.turnTeam = 'ally'; // 'ally' or 'enemy'
    this.selectedUnit = null;
  }

  units(team) {
    if (team === 'ally') return this.allies;
    if (team === 'enemy') return this.enemies;
    return [...this.allies, ...this.enemies];
  }

  livingUnits(team) {
    return this.units(team).filter(u => u.alive());
  }

  currentTeamAllActed() {
    return this.livingUnits(this.turnTeam).every(u => u.acted);
  }

  endTurnIfNeeded() {
    if (this.currentTeamAllActed()) {
      this.units(this.turnTeam).forEach(u => u.acted = false);
      this.turnTeam = this.turnTeam === 'ally' ? 'enemy' : 'ally';
      return this.turnTeam; // ← ここ大事
    }
    return null;
  }

  isBattleFinished() {
    const alliesAlive = this.livingUnits('ally').length > 0;
    const enemiesAlive = this.livingUnits('enemy').length > 0;
    if (!alliesAlive || !enemiesAlive) {
      return true;
    }
    return false;
  }

  damage(user, target) {
    const raw = user.atk - target.def;
    return Math.max(1, raw);
  }

  attack(user, target) {
    const dmg = this.damage(user, target);
    target.takeDamage(dmg);
    user.acted = true;
    
     return dmg; // ★ ここでダメージ値を返す
  }
}

TacticsBattle.prototype.isBattleFinished = function() {
    return this.livingUnits('enemy').length === 0 || this.livingUnits('ally').length === 0;
};


function Scene_Tactics() {
  this.initialize(...arguments);
}

Scene_Tactics.prototype = Object.create(Scene_Base.prototype);
Scene_Tactics.prototype.constructor = Scene_Tactics;
Scene_Tactics.prototype.enemyStepTowards = function(enemy, target) {
    const map = this._battle.map;
    const candidates = [];

    // X方向
    if (target.x > enemy.x) {
        candidates.push({ x: enemy.x + 1, y: enemy.y });
    } else if (target.x < enemy.x) {
        candidates.push({ x: enemy.x - 1, y: enemy.y });
    }

    // Y方向
    if (target.y > enemy.y) {
        candidates.push({ x: enemy.x, y: enemy.y + 1 });
    } else if (target.y < enemy.y) {
        candidates.push({ x: enemy.x, y: enemy.y - 1 });
    }

    // 候補の中から、マップ内＆空きマスのやつを一つ選ぶ
    for (const c of candidates) {
        if (!this._battle.map.inBounds(c.x, c.y)) continue;// マップ外
         if (!map.isPassable(c.x, c.y)) continue;      // ★ 壁など通行不能
        if (!this.isTileEmpty(c.x, c.y)) continue;// 他ユニット
        return c;
    }

    // 動けるマスがなければ何もしない
    return null;
};


Scene_Tactics.prototype.startPhaseBanner = function(team) {
    // 既に出てたら消す
    if (this._phaseSprite) {
        this.removeChild(this._phaseSprite);
        this._phaseSprite = null;
    }

    const w = 260;
    const h = 60;
    const bmp = new Bitmap(w, h);

    // 背景
    bmp.fillRect(0, 0, w, h, "rgba(0, 0, 0, 0.7)");

    // 枠線
    bmp.fillRect(0, 0, w, 2, "#ffffff");
    bmp.fillRect(0, h - 2, w, 2, "#ffffff");
    bmp.fillRect(0, 0, 2, h, "#ffffff");
    bmp.fillRect(w - 2, 0, 2, h, "#ffffff");

    // テキスト
    bmp.textColor = "#ffffff";
    bmp.outlineColor = "#000000";
    bmp.outlineWidth = 4;

    const text = (team === "ally") ? "味方ターン" : "敵ターン";
    bmp.drawText(text, 0, 10, w, 40, "center");

    const sprite = new Sprite(bmp);
    sprite.x = (Graphics.boxWidth - w) / 2;
    sprite.y = (Graphics.boxHeight - h) / 2;
    sprite.opacity = 0;   // 最初は透明

    this._phaseSprite = sprite;
    this._phaseTimer = 60; // 60フレームくらい表示（1秒前後）

    this.addChild(sprite);
};


Scene_Tactics.prototype.showDamageText = function(target, dmg) {
    const cellW = this._cellW;
    const cellH = this._cellH;

    // ダメージ表示用ビットマップ
    const bmp = new Bitmap(48, 24);
    bmp.fontSize = 20;
    bmp.textColor = "#ffffff";
    bmp.outlineColor = "#000000";
    bmp.outlineWidth = 4;
    bmp.drawText(String(dmg), 0, 0, bmp.width, bmp.height, "center");

    const sprite = new Sprite(bmp);

    // ターゲットマスの中央あたりに配置
    sprite.x = target.x * cellW + (cellW - bmp.width) / 2;
    sprite.y = target.y * cellH + (cellH - bmp.height) / 2;

    // アニメ用の簡単なプロパティ
    sprite._vy = -1;   // 上方向の速度
    sprite._life = 30; // 生存フレーム数

    this._damageTexts.push(sprite);
    this.addChild(sprite);
};









Scene_Tactics.prototype.tryActSelectedUnit = function() {
    const u = this._selectedUnit;
    if (!u) return;

    const tx = this._cursorX;
    const ty = this._cursorY;
    const target = this.unitAt(tx, ty);

    
const canMoveTo = this._moveRange.some(t => t.x === tx && t.y === ty);

    // ★ まだ移動していない場合
    if (!this._selectedUnitMoved) {

        // ■ まず移動判定
        if (!target && canMoveTo) {
            // 移動だけして、行動はまだ終わらせない
            u.x = tx;
            u.y = ty;
            this._selectedUnitMoved = true;

            // もうこれ以上は移動させないので移動範囲は消す
            this._moveRange = [];

            // この位置からの攻撃可能範囲を表示
            this.updateSelectedThreatRangeAfterMove();

            // 敵の範囲はそのままでもいいし、消したければここで消す
            // this._enemyMoveRange = [];
            // this._enemyThreatRange = [];

            this.redrawBoard();
            return;
        }

        // ■（移動前でも）その場から攻撃できるなら攻撃
        if (target && target.team !== u.team && this.inAttackRange(u, target)) {
            const dmg = this._battle.attack(u, target);
            this.showDamageText(target, dmg);

            u.acted = true;
            this._selectedUnit = null;
            this._moveRange = [];
            this._enemyMoveRange = [];
            this._enemyThreatRange = [];
            this._selectedThreatRange = [];
            this._selectedUnitMoved = false;

            const newTeam = this._battle.endTurnIfNeeded();
            if (newTeam) this.startPhaseBanner(newTeam);

            this.redrawBoard();
            if (this._battle.isBattleFinished()) SceneManager.pop();
            return;
        }

        // ここまで来たら何もできない
        return;
    }

    // ★ ここから「移動後」の処理（_selectedUnitMoved === true）

    // 移動後はもう移動させない。攻撃だけチェックする
    if (target && target.team !== u.team && this.inAttackRange(u, target)) {
        const dmg = this._battle.attack(u, target);
        this.showDamageText(target, dmg);

        u.acted = true;
        this._selectedUnit = null;
        this._moveRange = [];
        this._enemyMoveRange = [];
        this._enemyThreatRange = [];
        this._selectedThreatRange = [];
        this._selectedUnitMoved = false;

        const newTeam = this._battle.endTurnIfNeeded();
        if (newTeam) this.startPhaseBanner(newTeam);

        this.redrawBoard();
        if (this._battle.isBattleFinished()) SceneManager.pop();
        return;
    }

    // 攻撃できないマスなら何もしない（or メッセージ出してもいい）
};



    






Scene_Tactics.prototype.updateEnemyTurn = function() {
    const enemies = this._battle.livingUnits('enemy');
    const allies  = this._battle.livingUnits('ally');
    if (enemies.length === 0 || allies.length === 0) return;

    for (const enemy of enemies) {
        if (!enemy.alive()) continue;
        if (allies.length === 0) break;

        // 移動可能回数ぶんループ
        for (let stepCount = 0; stepCount < enemy.mov; stepCount++) {

            // 毎ステップごとに一番近い味方を再計算
            let target = null;
            let minDist = Infinity;
            for (const a of allies) {
                const d = Math.abs(a.x - enemy.x) + Math.abs(a.y - enemy.y);
                if (d < minDist) {
                    minDist = d;
                    target = a;
                }
            }
            if (!target) break;

             // ★ 射程内ならもう動かず攻撃
    if (this.inAttackRange(enemy, target)) {
        const dmg = this._battle.attack(enemy, target);
        this.showDamageText(target, dmg);
        break;
    }

            // まだ遠いなら1マスだけ近づく
            const step = this.enemyStepTowards(enemy, target);
            if (!step) break; // 動けないなら終了

            enemy.x = step.x;
            enemy.y = step.y;
        }

        enemy.acted = true;
    }

  

    // 敵全員行動終わり → 行動フラグリセットして味方ターンへ
    this._battle.units('enemy').forEach(u => u.acted = false);
    this._battle.turnTeam = 'ally';

    this.redrawBoard();
    this.startPhaseBanner('ally');
};
Scene_Tactics.prototype.inAttackRange = function(attacker, target) {
    const dist = Math.abs(attacker.x - target.x) + Math.abs(attacker.y - target.y);
    return dist >= attacker.rangeMin && dist <= attacker.rangeMax;
};

Scene_Tactics.prototype.createMapBackground = function() {
    // Spriteset_Map を丸ごと乗せると、
    // タイル・遠景・イベントグラフィックまで全部描画される
    this._spriteset = new Spriteset_Map();
    this.addChild(this._spriteset);
};



Scene_Tactics.prototype.initialize = function() {
  Scene_Base.prototype.initialize.call(this);
};

Scene_Tactics.prototype.create = function() {
  Scene_Base.prototype.create.call(this);
    this.createWindowLayer();

    // ★ 今いるマップの見た目をそのまま背景に使う
    this.createMapBackground();
 // 背景（今までどおり）
    this._spriteset = new Spriteset_Map();
    this.addChild(this._spriteset);

    // ★ステージ番号を変数から読む（なければ1）
    const STAGE_VAR_ID = 1; // ツクール側で決める
    const stageId = $gameVariables.value(STAGE_VAR_ID) || 1;

    // ★ステージ定義からバトルを生成
    this._battle = TacticsStages.createBattle(stageId);


  // ===== セルサイズ計算 =====
    this._cellW = $gameMap.tileWidth()*2;   // 48（MV/MZなら）
    this._cellH = $gameMap.tileHeight()*2;  // 48

  // とりあえずテスト用：グリッドを描くスプライト
  this.createBoardSprite();
  
  // ===== カーソル関連 =====
  this._cursorX = 0;
  this._cursorY = 0;
  this._selectedUnit = null; // 選択中ユニット（いなければnull）
  
  this._moveRange = []; // ★移動範囲ハイライト用
  this._damageTexts = [];
this._enemyMoveRange = [];   // ★敵の移動範囲
this._enemyThreatRange = [];   // ★敵の攻撃可能範囲（濃赤）
this._selectedThreatRange = [];  // ★自分ユニットの攻撃可能範囲（緑）

// ★ 自分だけプレビュー中かどうか
this._selfPreviewMode = false;

// ★ このユニットがもう“移動済み”かどうか
this._selectedUnitMoved = false;


    // ★ ターン演出用
    this._phaseSprite = null; // 現在表示中のバナー
    this._phaseTimer = 0;     // 残りフレーム



  this.createCursorSprite();
  this.updateCursorPosition();



};







Scene_Tactics.prototype.unitAt = function(x, y) {
  const all = [...this._battle.allies, ...this._battle.enemies];
  return all.find(u => u.alive() && u.x === x && u.y === y) || null;
};

Scene_Tactics.prototype.isTileEmpty = function(x, y) {
  return !this.unitAt(x, y);
};










Scene_Tactics.prototype.createBoardSprite = function() {
    const w = this._battle.map.width  * this._cellW;
    const h = this._battle.map.height * this._cellH;
  const bmp = new Bitmap(w, h);
  this._boardSprite = new Sprite(bmp);

    // 画面左上からピッタリ合わせたいなら 0,0
    this._boardSprite.x = 0;
    this._boardSprite.y = 0;

  this.addChild(this._boardSprite);
  this.redrawBoard();
};

Scene_Tactics.prototype.redrawBoard = function() {
  const bmp = this._boardSprite.bitmap;
  bmp.clear();
  const cellW = this._cellW;
  const cellH = this._cellH;

  // グリッド線
  for (let y = 0; y < this._battle.map.height; y++) {
    for (let x = 0; x < this._battle.map.width; x++) {
          
      bmp.fillRect(x * cellW, y * cellH, cellW, 1, "#666666");
      bmp.fillRect(x * cellW, y * cellH, 1, cellH, "#666666");
    }
  }


  // ★ここ：_moveRange が undefined/null でも平気なようにする
  const range = this._moveRange || [];
  for (const tile of range) {
    const x = tile.x;
    const y = tile.y;
    bmp.fillRect(
      x * cellW + 2,
      y * cellH + 2,
      cellW - 4,
      cellH - 4,
      "rgba(0, 0, 255, 0.3)"
    ); 
  }
// ★ 選択中ユニットの攻撃可能範囲（緑）
const srange = this._selectedThreatRange || [];
for (const tile of srange) {
    bmp.fillRect(
        tile.x * cellW + 4,
        tile.y * cellH + 4,
        cellW - 8,
        cellH - 8,
        "rgba(0, 255, 0, 0.35)"
    );
}
// ★ 敵の移動範囲（薄い赤）
const emove = this._enemyMoveRange || [];
for (const tile of emove) {
    bmp.fillRect(
        tile.x * cellW + 2,
        tile.y * cellH + 2,
        cellW - 4,
        cellH - 4,
        "rgba(255, 0, 0, 0.18)" // ← かなり薄め
    );
}

// ★ 敵の攻撃可能範囲（濃い赤）
const ethreat = this._enemyThreatRange || [];
for (const tile of ethreat) {
    bmp.fillRect(
        tile.x * cellW + 2,
        tile.y * cellH + 2,
        cellW - 4,
        cellH - 4,
        "rgba(255, 0, 0, 0.45)" // ← 濃いめ
    );
    }

  


/*
  // ユニット描画（味方=青、敵=赤）
  const drawUnits = (units, color) => {
    for (const u of units) {
      if (!u.alive()) continue;
      const cx = u.x * cellW;
      const cy = u.y * cellH;
      bmp.fillRect(cx + 4, cy + 4, cellW - 8, cellH - 8, color);
      bmp.drawText(u.name, cx, cy, cellW, cellH, 'center');
    }
  };
  drawUnits(this._battle.allies, "#3344ff");
  drawUnits(this._battle.enemies, "#ff3333");

*/

// ★最後に「ユニット＋HPバー」を描画
this.drawUnitsWithHp(this._battle.allies,  "rgba(80, 160, 255, 0.9)", "rgba(0, 255, 0, 0.9)");
this.drawUnitsWithHp(this._battle.enemies, "rgba(255, 80, 80, 0.9)",  "rgba(0, 255, 0, 0.9)");


};


Scene_Tactics.prototype.drawUnitsWithHp = function(units, barColor) {
    const bmp   = this._boardSprite.bitmap;
    const cellW = this._cellW;
    const cellH = this._cellH;

    for (const u of units) {
        if (!u.alive || u.hp <= 0) continue; // aliveメソッドがあるならそっち使ってOK

        const x = u.x * cellW;
        const y = u.y * cellH;

        // ★ユニット本体（色付きの四角）※既に描いてるならここは省略してOK
        const bodySize = Math.min(cellW, cellH) - 8;
        const bx = x + (cellW - bodySize) / 2;
        const by = y + (cellH - bodySize) / 2;
        bmp.fillRect(bx, by, bodySize, bodySize, "rgba(255, 255, 255, 0.9)");

        // ★HPバー（下側にちっちゃく）
        const barW = cellW - 6;
        const barH = 5;
        const barX = x + 3;
        const barY = y + cellH - barH - 2;

        // 背景（黒）
        bmp.fillRect(barX, barY, barW, barH, "rgba(0, 0, 0, 0.7)");

        // 残りHP
        const rate = Math.max(0, Math.min(1, u.hp / u.maxHp));
        const hpW  = Math.max(1, Math.floor(barW * rate));
        bmp.fillRect(barX + 1, barY + 1, hpW - 2, barH - 2, barColor);
    }
};








Scene_Tactics.prototype.drawUnitsWithHp = function(units, color) {
  const bmp = this._boardSprite.bitmap;
  const cellW = this._cellW;
  const cellH = this._cellH;

  for (const u of units) {
    if (!u.alive()) continue;

    const cx = u.x * cellW;
    const cy = u.y * cellH;

    // 本体の四角
    bmp.fillRect(cx + 4, cy + 4, cellW - 8, cellH - 16, color); // 少し上に縮める

    // 名前
    bmp.drawText(u.name, cx, cy + 4, cellW, 24, 'center');

    // ★ HPバー
    const barWidth = cellW - 8;
    const barHeight = 6;
    const barX = cx + 4;
    const barY = cy + cellH - barHeight - 4;

    // 背景（黒）
    bmp.fillRect(barX, barY, barWidth, barHeight, "#000000");

    const rate = u.hp / u.maxHp;
    const hpWidth = Math.max(0, Math.floor(barWidth * rate));

    // 残りHP（緑）
    bmp.fillRect(barX, barY, hpWidth, barHeight, "#00ff00");
  }
};

Scene_Tactics.prototype.updatePhaseBanner = function() {
    if (!this._phaseSprite) return;
    if (this._phaseTimer <= 0) {
        // 念のためクリーンアップ
        this.removeChild(this._phaseSprite);
        this._phaseSprite = null;
        return;
    }

    this._phaseTimer--;

    // 前半でフェードイン、後半でフェードアウト
    const total = 60;
    const half = total / 2;
    const s = this._phaseSprite;

    if (this._phaseTimer > half) {
        // フェードイン
        const t = total - this._phaseTimer; // 0→half
        s.opacity = 255 * (t / half);
    } else {
        // フェードアウト
        const t = this._phaseTimer; // half→0
        s.opacity = 255 * (t / half);
    }
};
Scene_Tactics.prototype.update = function() {



  if (this._onBattleEndPending==true) {
    this._onBattleEndPending = false;
    SceneManager.pop(); // ★ 前のシーンに戻る
    return;
}




  Scene_Base.prototype.update.call(this);
    // ★ まずバナーを更新
    this.updatePhaseBanner();

    // ★ 演出中はそれ以外止める
    if (this._phaseTimer > 0) {
        // ダメージ数字だけは動かしてOKにする
        this.updateDamageTexts();
        this.refreshStatusWindow();
        return;
    }



    if (this._battle.turnTeam === 'ally') {
        // 味方ターン：今までの操作
        this.updateCursorControl();
        this.updateOkCancel();
    } else {
        // 敵ターン：自動行動
        this.updateEnemyTurn();
    }
    // ★ダメージ演出更新
    this.updateDamageTexts();
    // ★ ステータス更新
    this.refreshStatusWindow();

    // ★ 勝利条件チェック
    if (this._battle.isBattleFinished()) {
        this.onBattleEnd();
    }




  // ここに「カーソル」「移動入力」「攻撃入力」「ターン終了処理」を少しずつ足していく
};
Scene_Tactics.prototype.updateDamageTexts = function() {
    for (let i = this._damageTexts.length - 1; i >= 0; i--) {
        const s = this._damageTexts[i];
        s.y += s._vy;
        s._life--;

        if (s._life < 10) {
            s.opacity = 255 * (s._life / 10);
        }

        if (s._life <= 0) {
            this.removeChild(s);
            this._damageTexts.splice(i, 1);
        }
    }
};

// --- ★4-3. カーソル移動（ここに書く） ---
Scene_Tactics.prototype.updateCursorControl = function() {
  let moved = false;

  if (Input.isTriggered("left")) {
    if (this._cursorX > 0) {
      this._cursorX--;
      moved = true;
    }
  } else if (Input.isTriggered("right")) {
    if (this._cursorX < this._battle.map.width - 1) {
      this._cursorX++;
      moved = true;
    }
  } else if (Input.isTriggered("up")) {
    if (this._cursorY > 0) {
      this._cursorY--;
      moved = true;
    }
  } else if (Input.isTriggered("down")) {
    if (this._cursorY < this._battle.map.height - 1) {
      this._cursorY++;
      moved = true;
    }
  }

  // --- 決定／キャンセル処理 ---
Scene_Tactics.prototype.updateOkCancel = function() {
// 単体待機：選択中＋Wキー
if (this._selectedUnit && Input.isTriggered("pagedown")) { // Wキー
    const u = this._selectedUnit;
    u.acted = true;
    this._selectedUnit = null;
    this._moveRange = [];

    const newTeam = this._battle.endTurnIfNeeded();
    if (newTeam) {
        this.startPhaseBanner(newTeam);
    }
    this.redrawBoard();
    return;
}
  // ★ 追加：Qキーでターン終了
  if (Input.isTriggered("pageup")) { // Qキー
    this.forceEndTurn();
    return;
  }

    // ★ シフト：自分だけ範囲プレビューON/OFF
    if (this._selectedUnit && Input.isTriggered("shift")) {
        // モード反転
        this._selfPreviewMode = !this._selfPreviewMode;

        if (this._selfPreviewMode) {
            // 自分の攻撃範囲を計算して表示
            this.updateSelectedThreatRange();

            // 敵の範囲は一旦全部消す
            this._enemyMoveRange = [];
            this._enemyThreatRange = [];
        } else {
            // 自分の攻撃範囲を消す
            this._selectedThreatRange = [];

            // 敵の範囲を再計算して元に戻す
            this.updateAllEnemyMoveRange();
        }
        this.redrawBoard();
        return;
    }

    if (Input.isTriggered("cancel")) {

    if (this._selectedUnit && this._selectedUnitMoved) {
        // 移動済みなら、その場で待機扱いにして行動終了
        const u = this._selectedUnit;
        u.acted = true;
        this._selectedUnit = null;
        this._moveRange = [];
        this._enemyMoveRange = [];
        this._enemyThreatRange = [];
        this._selectedThreatRange = [];
        this._selectedUnitMoved = false;

        const newTeam = this._battle.endTurnIfNeeded();
        if (newTeam) this.startPhaseBanner(newTeam);
        this.redrawBoard();
        return;
    }


        this._selectedUnit = null;
        this._moveRange = []; // ★範囲消す
        this._enemyMoveRange = []; // ★ 敵範囲も消す
        this._enemyThreatRange = [];
         this._selectedThreatRange = []; // ★ここでも消す
         this._selfPreviewMode = false;   // ★ モードもリセット
        return;
    }
const newTeam = this._battle.endTurnIfNeeded();
if (newTeam) {
    this.startPhaseBanner(newTeam);
}
    if (Input.isTriggered("ok")) {
        if (!this._selectedUnit) {
            this.trySelectUnit();
        } else {
            this.tryActSelectedUnit(); // ★移動 or 攻撃をまとめて処理
        }
    }
};

  if (moved) {
    this.updateCursorPosition();
  }
};

Scene_Tactics.prototype.onBattleEnd = function() {
    if (this._battle.livingUnits('enemy').length === 0) {
        // ★勝利SE
        AudioManager.playSe({
            name: "Applause1", // プロジェクト内の SE ファイル名に合わせる
            volume: 90,
            pitch: 100,
            pan: 0

        

        });
       $gameSwitches.setValue(10, true);//このあたりでステージごとのクリア履歴
        $gameMessage.add("勝利した！");

// ★ステージ番号を1つ進める（最大10まで）
        const STAGE_VAR_ID = 1;
        const current = $gameVariables.value(STAGE_VAR_ID) || 1;
        if (current < 10) {
            $gameVariables.setValue(STAGE_VAR_ID, current + 1);


        }

    } else {
        // ★敗北SE
        AudioManager.playSe({
            name: "Bite",
            volume: 90,
            pitch: 100,
            pan: 0
        });

        $gameMessage.add("敗北した……");
        $gameSwitches.setValue(10, false);
    }


    // 画面にメッセージを出す時間を少し待ってから戻す
    this._phaseTimer = 120; // 2秒ほど
    this._onBattleEndPending = true;
};


// --- ユニット検索ヘルパ ---
Scene_Tactics.prototype.unitAt = function(x, y) {
    const all = [...this._battle.allies, ...this._battle.enemies];
    return all.find(u => u.alive() && u.x === x && u.y === y) || null;
};

Scene_Tactics.prototype.isTileEmpty = function(x, y) {
    return !this.unitAt(x, y);
};

// --- ユニット選択 ---
Scene_Tactics.prototype.trySelectUnit = function() {
    const u = this.unitAt(this._cursorX, this._cursorY);
    if (!u) return;
    if (u.team !== this._battle.turnTeam) return;
    if (u.acted) return;
    this._selectedUnit = u;
       this._selectedUnitMoved = false;   // ★ 新しく選んだのでまだ未移動
    this._moveRange = this.computeMoveRange(u); // ★ここで使う
    
        // 敵範囲は通常表示に戻す
    this._selfPreviewMode = false;
    this._selectedThreatRange = [];
    
    // ★ 敵全員の移動範囲をまとめて計算

    this.updateAllEnemyMoveRange();
      this.redrawBoard();
};




Scene_Tactics.prototype.computeAttackRangeFrom = function(unit, x, y) {
    const map = this._battle.map;
    const result = [];
    const used = {};

    for (let dy = -unit.rangeMax; dy <= unit.rangeMax; dy++) {
        for (let dx = -unit.rangeMax; dx <= unit.rangeMax; dx++) {
            const tx = x + dx;
            const ty = y + dy;
            if (!map.inBounds(tx, ty)) continue;

            const dist = Math.abs(dx) + Math.abs(dy);
            if (dist < unit.rangeMin || dist > unit.rangeMax) continue;

            const key = `${tx},${ty}`;
            if (!used[key]) {
                used[key] = true;
                result.push({ x: tx, y: ty });
            }
        }
    }
    return result;
};

Scene_Tactics.prototype.updateSelectedThreatRangeAfterMove = function() {
    const u = this._selectedUnit;
    if (!u) {
        this._selectedThreatRange = [];
        return;
    }
    this._selectedThreatRange = this.computeAttackRangeFrom(u, u.x, u.y);
};











Scene_Tactics.prototype.updateSelectedThreatRange = function() {
    const u = this._selectedUnit;
    if (!u) {
        this._selectedThreatRange = [];
        return;
    }

    const map = this._battle.map;
    const result = [];
    const used = {};

    // すでに計算済みの移動範囲があるなら使う
    const moveTiles = this._moveRange && this._moveRange.length > 0
        ? this._moveRange
        : this.computeMoveRange(u);

    // 立てるマス = 現在位置 + 移動マス
    const standTiles = [{ x: u.x, y: u.y }, ...moveTiles];

    for (const s of standTiles) {
        for (let dy = -u.rangeMax; dy <= u.rangeMax; dy++) {
            for (let dx = -u.rangeMax; dx <= u.rangeMax; dx++) {
                const tx = s.x + dx;
                const ty = s.y + dy;
                if (!map.inBounds(tx, ty)) continue;

                const dist = Math.abs(dx) + Math.abs(dy);
                if (dist < u.rangeMin || dist > u.rangeMax) continue;

                const key = `${tx},${ty}`;
                if (!used[key]) {
                    used[key] = true;
                    result.push({ x: tx, y: ty });
                }
            }
        }
    }

    this._selectedThreatRange = result;
};
Scene_Tactics.prototype.updateAllEnemyMoveRange = function() {
    const enemies = this._battle.livingUnits('enemy');
    const map = this._battle.map;

    const moveResult = [];      // 歩けるマス
    const moveUsed   = {};      // "x,y" → true

    const threatResult = [];    // 攻撃が届くマス
    const threatUsed   = {};    // "x,y" → true

    for (const e of enemies) {
        // 1. 移動可能マス
        const moveTiles = this.computeMoveRange(e); // 自分のマスは含まない想定

        // 移動マス登録
        for (const t of moveTiles) {
            const key = `${t.x},${t.y}`;
            if (!moveUsed[key]) {
                moveUsed[key] = true;
                moveResult.push({ x: t.x, y: t.y });
            }
        }

        // 「立てるマス」＝現在位置＋移動後
        const standTiles = [{ x: e.x, y: e.y }, ...moveTiles];

        // 2. 各立ち位置から攻撃範囲を塗る
        for (const s of standTiles) {
            for (let dy = -e.rangeMax; dy <= e.rangeMax; dy++) {
                for (let dx = -e.rangeMax; dx <= e.rangeMax; dx++) {
                    const tx = s.x + dx;
                    const ty = s.y + dy;
                    if (!map.inBounds(tx, ty)) continue;

                    const dist = Math.abs(dx) + Math.abs(dy);
                    if (dist < e.rangeMin || dist > e.rangeMax) continue;

                    const key = `${tx},${ty}`;
                    if (!threatUsed[key]) {
                        threatUsed[key] = true;
                        threatResult.push({ x: tx, y: ty });
                    }
                }
            }
        }
    }

    this._enemyMoveRange   = moveResult;
    this._enemyThreatRange = threatResult;
};
Scene_Tactics.prototype.computeMoveRange = function(unit) {
  const map = this._battle.map;      // ★ 追加
  const maxStep = unit.mov;

  // "x,y" → コスト のマップ
  const costMap = {};
  const key = (x, y) => `${x},${y}`;

  const result = [];
  const queue = [];

  // 開始地点
  queue.push({ x: unit.x, y: unit.y, c: 0 });
  costMap[key(unit.x, unit.y)] = 0;

  while (queue.length > 0) {
    const node = queue.shift();
    const x = node.x;
    const y = node.y;
    const c = node.c;

    // 自分が立っているマスは「範囲」には入れない（ハイライトだけ）
    if (!(x === unit.x && y === unit.y)) {
      result.push({ x, y });
    }

    if (c >= maxStep) continue;

    const dirs = [
      { dx: 1, dy: 0 },
      { dx: -1, dy: 0 },
      { dx: 0, dy: 1 },
      { dx: 0, dy: -1 },
    ];

    for (const d of dirs) {
      const nx = x + d.dx;
      const ny = y + d.dy;


      // マップ外
      if (!map.inBounds(nx, ny)) continue;

        // ★ 通行不能マスならスキップ（ここを追加）
  if (!map.isPassable(nx, ny)) continue;
      // 他ユニットがいるマスには入れない（※開始マスは例外）
      const other = this.unitAt(nx, ny);
      if (other && !(nx === unit.x && ny === unit.y)) continue;

      const nKey = key(nx, ny);
      const nCost = c + 1;

      if (costMap[nKey] == null || nCost < costMap[nKey]) {
        costMap[nKey] = nCost;
        queue.push({ x: nx, y: ny, c: nCost });
      }
    }
  }

  return result;
};


Scene_Tactics.prototype.forceEndTurn = function() {
  // 今のチーム
  const team = this._battle.turnTeam;

  // 現在生きてるユニット全員を「行動済み」にする
  const units = this._battle.livingUnits(team);
  for (const u of units) {
    u.acted = true;
  }

  // 選択状態・移動範囲をクリア
  this._selectedUnit = null;
  this._moveRange = [];
this._enemyMoveRange = []; // ★
this._enemyThreatRange = [];
this._selectedThreatRange = []; // ★追加
this._selfPreviewMode = false;
  // endTurnIfNeeded でターン切り替え（さっき拡張したやつ）
  const newTeam = this._battle.endTurnIfNeeded();
  if (newTeam) {
    // フェーズ演出があるならここで呼ぶ
    this.startPhaseBanner(newTeam);
  }

  // 画面更新
  this.redrawBoard();
};

// --- ユニット移動 ---
Scene_Tactics.prototype.tryMoveSelectedUnit = function() {
    const u = this._selectedUnit;
    if (!u) return;

    const tx = this._cursorX;
    const ty = this._cursorY;

    if (u.x === tx && u.y === ty) {
        this._selectedUnit = null;
        return;
    }

    const dist = Math.abs(tx - u.x) + Math.abs(ty - u.y);
    if (dist > u.mov) return;
    if (!this._battle.map.inBounds(tx, ty)) return;
    if (!this.isTileEmpty(tx, ty)) return;

    u.x = tx;
    u.y = ty;
    u.acted = true;
    this._selectedUnit = null;
    this._moveRange = []; // ★範囲消す
    this._enemyMoveRange = []; // ★
    this._enemyThreatRange = [];
    this._selectedThreatRange = []; // ★追加
this._selfPreviewMode = false;
const newTeam = this._battle.endTurnIfNeeded();
if (newTeam) {
    this.startPhaseBanner(newTeam);
}

    this.redrawBoard();
};
Scene_Tactics.prototype.createCursorSprite = function() {
  const cellW = this._cellW;
  const cellH = this._cellH;
  const bmp = new Bitmap(cellW, cellH);

  // 黄色い枠っぽいのを描く
  const borderColor = "#ffff00";
  // 上
  bmp.fillRect(0, 0, cellW, 2, borderColor);
  // 下
  bmp.fillRect(0, cellH - 2, cellW, 2, borderColor);
  // 左
  bmp.fillRect(0, 0, 2, cellH, borderColor);
  // 右
  bmp.fillRect(cellW - 2, 0, 2, cellH, borderColor);

  this._cursorSprite = new Sprite(bmp);
  this.addChild(this._cursorSprite);


  this.createStatusWindow();
};



Scene_Tactics.prototype.refreshStatusWindow = function() {
    if (!this._statusWindow) return;

    const win = this._statusWindow;
    win.contents.clear(); // ★ 毎回まず消す

    // ターン表示
    const turnText = (this._battle.turnTeam === 'ally') ? "味方ターン" : "敵ターン";
    win.drawText(turnText, 0, -6, win.contentsWidth(), 'left');

    // ★ 表示対象のユニットを一人だけ決める
    let u = null;

    // 1. 選択中ユニットがいればそれを優先
    if (this._selectedUnit) {
        u = this._selectedUnit;
    } else {
        // 2. いなければカーソル下のユニット
        const cu = this.unitAt(this._cursorX, this._cursorY);
        if (cu) u = cu;
    }

    // 誰もいなければ終わり
    if (!u) return;

    // ★ ここで1回だけ描く
    const y = 20;
    const text =
        `${u.team === 'ally' ? "味方" : "敵"} ${u.name}  ` +
        `HP:${u.hp}/${u.maxHp}  ` +
        `ATK:${u.atk}  DEF:${u.def}  MOV:${u.mov}  ` +
        `RNG:${u.rangeMin}-${u.rangeMax}`;

    win.drawText(text, 0, y, win.contentsWidth(), 'left');
};




Scene_Tactics.prototype.createStatusWindow = function() {
    const h = 72;
    const yOffset = 0; // ← 上に持ち上げたいピクセル数（お好みで）
    const rect = new Rectangle(
        0,
        Graphics.boxHeight - h- yOffset, // ← ここをちょっと引く
        Graphics.boxWidth,
        h
    );
    this._statusWindow = new Window_Base(rect);
    this.addChild(this._statusWindow);
    this.refreshStatusWindow();
};



Scene_Tactics.prototype.updateCursorPosition = function() {
  this._cursorSprite.x = this._cursorX * this._cellW;
  this._cursorSprite.y = this._cursorY * this._cellH;
};



